/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    private final Map<Long, Object> recipeCache = new HashMap<Long, Object>();
    private final Map<Long, List<Object>> recipeListCache = new HashMap<Long, List<Object>>();
    private final Random rand = new Random();

    @Inject(method={"getRecipeFor(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends IInventory, T extends IRecipe<C>> void onGetRecipe(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<Optional> c) {
        Object recipe;
        if (this.rand.nextInt(500) != 0 && inventoryIn != null && inventoryIn.func_70302_i_() > 0 && (recipe = this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn))) != null && recipeTypeIn.func_222148_a((IRecipe)recipe, worldIn, inventoryIn).isPresent()) {
            c.setReturnValue(Optional.of((IRecipe)recipe));
        }
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/Optional;"}, at={@At(value="RETURN")})
    private <C extends IInventory, T extends IRecipe<C>> void onEndGetRecipe(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<Optional<T>> c) {
        long hash;
        Optional val = (Optional)c.getReturnValue();
        if (val.isPresent() && inventoryIn != null && inventoryIn.func_70302_i_() > 0 && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            this.recipeCache.put(hash, val.get());
        }
    }

    @Inject(method={"getRecipesFor"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends IInventory, T extends IRecipe<C>> void onGetRecipes(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable c) {
        List<Object> recipes;
        if (this.rand.nextInt(500) != 0 && inventoryIn != null && inventoryIn.func_70302_i_() > 0 && (recipes = this.recipeListCache.get(this.calcHash(inventoryIn, recipeTypeIn))) != null && !recipes.isEmpty() && recipeTypeIn.func_222148_a((IRecipe)recipes.get(0), worldIn, inventoryIn).isPresent()) {
            c.setReturnValue(new ArrayList<Object>(recipes));
        }
    }

    @Inject(method={"getRecipesFor"}, at={@At(value="RETURN")})
    private <C extends IInventory, T extends IRecipe<C>> void onEndgetRecipes(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn, CallbackInfoReturnable<List<T>> c) {
        long hash;
        List list = (List)c.getReturnValue();
        if (!list.isEmpty() && inventoryIn != null && inventoryIn.func_70302_i_() > 0 && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            this.recipeListCache.put(hash, new ArrayList(list));
        }
    }

    private long calcHash(IInventory inventory, IRecipeType type) {
        if (inventory == null) {
            return type.hashCode();
        }
        long hash = type.hashCode();
        int size = inventory.func_70302_i_();
        boolean onlyAir = true;
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_190926_b()) continue;
            hash = 31L * hash;
            hash += (long)stack.func_77973_b().hashCode();
            hash = hash * 31L + (long)stack.func_77952_i();
            if (stack.func_77942_o()) {
                hash = hash * 31L + (long)stack.func_77978_p().hashCode();
            }
            onlyAir = false;
        }
        if (onlyAir) {
            return -1L;
        }
        return hash;
    }
}

